<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2;

use Twilio\Options;
use Twilio\Values;

abstract class VerificationAttemptsSummaryOptions {
    /**
     * @param string $verifyServiceSid Filter the verification attempts considered
     *                                 on the summary by verify service.
     * @param \DateTime $dateCreatedAfter Consider verification attempts create
     *                                    after this date on the summary.
     * @param \DateTime $dateCreatedBefore Consider verification attempts created
     *                                     before this date on the summary.
     * @param string $country Filter verification attempts considered on the
     *                        summary by destination country.
     * @param string $channel Filter verification attempts considered on the
     *                        summary by communication channel.
     * @param string $destinationPrefix Filters the attempts considered on the
     *                                  summary by destination prefix.
     * @return FetchVerificationAttemptsSummaryOptions Options builder
     */
    public static function fetch(string $verifyServiceSid = Values::NONE, \DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $country = Values::NONE, string $channel = Values::NONE, string $destinationPrefix = Values::NONE): FetchVerificationAttemptsSummaryOptions {
        return new FetchVerificationAttemptsSummaryOptions($verifyServiceSid, $dateCreatedAfter, $dateCreatedBefore, $country, $channel, $destinationPrefix);
    }
}

class FetchVerificationAttemptsSummaryOptions extends Options {
    /**
     * @param string $verifyServiceSid Filter the verification attempts considered
     *                                 on the summary by verify service.
     * @param \DateTime $dateCreatedAfter Consider verification attempts create
     *                                    after this date on the summary.
     * @param \DateTime $dateCreatedBefore Consider verification attempts created
     *                                     before this date on the summary.
     * @param string $country Filter verification attempts considered on the
     *                        summary by destination country.
     * @param string $channel Filter verification attempts considered on the
     *                        summary by communication channel.
     * @param string $destinationPrefix Filters the attempts considered on the
     *                                  summary by destination prefix.
     */
    public function __construct(string $verifyServiceSid = Values::NONE, \DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $country = Values::NONE, string $channel = Values::NONE, string $destinationPrefix = Values::NONE) {
        $this->options['verifyServiceSid'] = $verifyServiceSid;
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        $this->options['country'] = $country;
        $this->options['channel'] = $channel;
        $this->options['destinationPrefix'] = $destinationPrefix;
    }

    /**
     * Filter used to consider only Verification Attempts of the given verify service on the summary aggregation.
     *
     * @param string $verifyServiceSid Filter the verification attempts considered
     *                                 on the summary by verify service.
     * @return $this Fluent Builder
     */
    public function setVerifyServiceSid(string $verifyServiceSid): self {
        $this->options['verifyServiceSid'] = $verifyServiceSid;
        return $this;
    }

    /**
     * Datetime filter used to consider only Verification Attempts created after this datetime on the summary aggregation. Given as GMT in RFC 2822 format.
     *
     * @param \DateTime $dateCreatedAfter Consider verification attempts create
     *                                    after this date on the summary.
     * @return $this Fluent Builder
     */
    public function setDateCreatedAfter(\DateTime $dateCreatedAfter): self {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        return $this;
    }

    /**
     * Datetime filter used to consider only Verification Attempts created before this datetime on the summary aggregation. Given as GMT in RFC 2822 format.
     *
     * @param \DateTime $dateCreatedBefore Consider verification attempts created
     *                                     before this date on the summary.
     * @return $this Fluent Builder
     */
    public function setDateCreatedBefore(\DateTime $dateCreatedBefore): self {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        return $this;
    }

    /**
     * Filter used to consider only Verification Attempts sent to the specified destination country on the summary aggregation.
     *
     * @param string $country Filter verification attempts considered on the
     *                        summary by destination country.
     * @return $this Fluent Builder
     */
    public function setCountry(string $country): self {
        $this->options['country'] = $country;
        return $this;
    }

    /**
     * Filter Verification Attempts considered on the summary aggregation by communication channel. Valid values are `SMS` and `CALL`
     *
     * @param string $channel Filter verification attempts considered on the
     *                        summary by communication channel.
     * @return $this Fluent Builder
     */
    public function setChannel(string $channel): self {
        $this->options['channel'] = $channel;
        return $this;
    }

    /**
     * Filter the Verification Attempts considered on the summary aggregation by Destination prefix. It is the prefix of a phone number in E.164 format.
     *
     * @param string $destinationPrefix Filters the attempts considered on the
     *                                  summary by destination prefix.
     * @return $this Fluent Builder
     */
    public function setDestinationPrefix(string $destinationPrefix): self {
        $this->options['destinationPrefix'] = $destinationPrefix;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.FetchVerificationAttemptsSummaryOptions ' . $options . ']';
    }
}