<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee\Resource;

use Google\Service\Apigee\GoogleCloudApigeeV1ListSecurityMonitoringConditionsResponse;
use Google\Service\Apigee\GoogleCloudApigeeV1SecurityMonitoringCondition;
use Google\Service\Apigee\GoogleProtobufEmpty;

/**
 * The "securityMonitoringConditions" collection of methods.
 * Typical usage is:
 *  <code>
 *   $apigeeService = new Google\Service\Apigee(...);
 *   $securityMonitoringConditions = $apigeeService->organizations_securityMonitoringConditions;
 *  </code>
 */
class OrganizationsSecurityMonitoringConditions extends \Google\Service\Resource
{
  /**
   * Create a security monitoring condition. (securityMonitoringConditions.create)
   *
   * @param string $parent Required. The parent resource name. Format:
   * `organizations/{org}`
   * @param GoogleCloudApigeeV1SecurityMonitoringCondition $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string securityMonitoringConditionId Optional. Optional: The
   * security monitoring condition id. If not specified, a monitoring condition
   * uuid will be generated by the backend. This value should be 4-63 characters,
   * and valid characters are /a-z-/.
   * @return GoogleCloudApigeeV1SecurityMonitoringCondition
   * @throws \Google\Service\Exception
   */
  public function create($parent, GoogleCloudApigeeV1SecurityMonitoringCondition $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], GoogleCloudApigeeV1SecurityMonitoringCondition::class);
  }
  /**
   * Delete a security monitoring condition. (securityMonitoringConditions.delete)
   *
   * @param string $name Required. The name of the security monitoring condition
   * to delete. Format: `organizations/{org}/securityMonitoringConditions/{securit
   * y_monitoring_condition}`
   * @param array $optParams Optional parameters.
   * @return GoogleProtobufEmpty
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], GoogleProtobufEmpty::class);
  }
  /**
   * Get a security monitoring condition. (securityMonitoringConditions.get)
   *
   * @param string $name Required. The name of the security monitoring condition
   * to get. Format: `organizations/{org}/securityMonitoringConditions/{security_m
   * onitoring_condition}`
   * @param array $optParams Optional parameters.
   * @return GoogleCloudApigeeV1SecurityMonitoringCondition
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], GoogleCloudApigeeV1SecurityMonitoringCondition::class);
  }
  /**
   * List security monitoring conditions.
   * (securityMonitoringConditions.listOrganizationsSecurityMonitoringConditions)
   *
   * @param string $parent Required. For a specific organization, list all the
   * security monitoring conditions. Format: `organizations/{org}`
   * @param array $optParams Optional parameters.
   *
   * @opt_param string filter Optional. Filter for the monitoring conditions. For
   * example: `profile=profile1 AND scope=env1`
   * @opt_param int pageSize Optional. The maximum number of monitoring conditions
   * to return.
   * @opt_param string pageToken Optional. A page token, received from a previous
   * `ListSecurityMonitoringConditions` call. Provide this to retrieve the
   * subsequent page.
   * @return GoogleCloudApigeeV1ListSecurityMonitoringConditionsResponse
   * @throws \Google\Service\Exception
   */
  public function listOrganizationsSecurityMonitoringConditions($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], GoogleCloudApigeeV1ListSecurityMonitoringConditionsResponse::class);
  }
  /**
   * Update a security monitoring condition. (securityMonitoringConditions.patch)
   *
   * @param string $name Identifier. Name of the security monitoring condition
   * resource. Format: organizations/{org}/securityMonitoringConditions/{security_
   * monitoring_condition}
   * @param GoogleCloudApigeeV1SecurityMonitoringCondition $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string updateMask Optional. The list of fields to update. Valid
   * fields to update are `profile`, `scope`, `include_all_resources`, `include`,
   * and `exclude`.
   * @return GoogleCloudApigeeV1SecurityMonitoringCondition
   * @throws \Google\Service\Exception
   */
  public function patch($name, GoogleCloudApigeeV1SecurityMonitoringCondition $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('patch', [$params], GoogleCloudApigeeV1SecurityMonitoringCondition::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OrganizationsSecurityMonitoringConditions::class, 'Google_Service_Apigee_Resource_OrganizationsSecurityMonitoringConditions');
