<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?php echo app('translator')->get('app.invoice'); ?></title>
    <?php if ($__env->exists('invoices.pdf.invoice_pdf_css')) echo $__env->make('invoices.pdf.invoice_pdf_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }

        a {
            text-decoration: none;
        }

        body {
            position: relative;
            width: 100%;
            height: auto;
            margin: 0 auto;
            color: #555555;
            background: #FFFFFF;
            font-size: 13px;
            /* font-family: Verdana, Arial, Helvetica, sans-serif; */
        }

        h2 {
            font-weight: normal;
        }

        header {
            padding: 10px 0;
        }

        #logo img {
            height: 50px;
            margin-bottom: 15px;
        }

        #details {
            margin-bottom: 25px;
        }

        #client {
            padding-left: 6px;
            float: left;
        }

        #client .to {
            color: #777777;
        }

        h2.name {
            font-size: 1.2em;
            font-weight: normal;
            margin: 0;
        }

        #invoice h1 {
            color: #0087C3;
            line-height: 2em;
            font-weight: normal;
            margin: 0 0 10px 0;
            font-size: 20px;
        }

        #invoice .date {
            font-size: 1.1em;
            color: #777777;
        }

        table {
            width: 100%;
            border-spacing: 0;
            /* margin-bottom: 20px; */
        }

        table th,
        table td {
            padding: 5px 8px;
            text-align: center;
        }

        table th {
            background: #EEEEEE;
        }

        table th {
            white-space: nowrap;
            font-weight: normal;
        }

        table td {
            text-align: right;
        }

        table td.desc h3,
        table td.qty h3 {
            font-size: 0.9em;
            font-weight: normal;
            margin: 0 0 0 0;
        }

        table .no {
            font-size: 1.2em;
            width: 10%;
            text-align: center;
            border-left: 1px solid #e7e9eb;
        }

        table .desc,
        table .item-summary {
            text-align: left;
        }

        table .unit {
            /* background: #DDDDDD; */
            border: 1px solid #e7e9eb;
        }


        table .total {
            background: #57B223;
            color: #FFFFFF;
        }

        table td.unit,
        table td.qty,
        table td.total {
            font-size: 1.2em;
            text-align: center;
        }

        table td.unit {
            width: 35%;
        }

        table td.desc {
            width: 45%;
        }

        table td.qty {
            width: 5%;
        }

        .status {
            margin-top: 15px;
            padding: 1px 8px 5px;
            font-size: 1.3em;
            width: 80px;
            float: right;
            text-align: center;
            display: inline-block;
        }

        .status.unpaid {
            background-color: #E7505A;
        }

        .status.paid {
            background-color: #26C281;
        }

        .status.cancelled {
            background-color: #95A5A6;
        }

        .status.error {
            background-color: #F4D03F;
        }

        table tr.tax .desc {
            text-align: right;
        }

        table tr.discount .desc {
            text-align: right;
            color: #E43A45;
        }

        table tr.subtotal .desc {
            text-align: right;
        }


        table tfoot td {
            padding: 10px;
            font-size: 1.2em;
            white-space: nowrap;
            border-bottom: 1px solid #e7e9eb;
            font-weight: 700;
        }

        table tfoot tr:first-child td {
            border-top: none;
        }

        table tfoot tr td:first-child {
            /* border: none; */
        }


        #notices {
            padding-left: 6px;
            border-left: 6px solid #0087C3;
        }

        #notices .notice {
            font-size: 1.2em;
        }

        footer {
            color: #777777;
            width: 100%;
            height: 30px;
            position: absolute;
            bottom: 0;
            border-top: 1px solid #e7e9eb;
            padding: 8px 0;
            text-align: center;
        }

        table.billing td {
            background-color: #fff;
        }

        table td#invoiced_to {
            text-align: left;
            padding-left: 0;
        }

        #notes {
            color: #767676;
            font-size: 11px;
        }

        .item-summary {
            font-size: 11px;
            padding-left: 0;
        }


        .page_break {
            page-break-before: always;
        }


        table td.text-center {
            text-align: center;
        }

        .word-break {
            word-wrap: break-word;
            word-break: break-all;
        }

        #invoice-table td {
            border-bottom: 1px solid #FFFFFF;
        }

        .border-left-0 {
            border-left: 0 !important;
        }

        .border-right-0 {
            border-right: 0 !important;
        }

        .border-top-0 {
            border-top: 0 !important;
        }

        .border-bottom-0 {
            border-bottom: 0 !important;
        }

        .h3-border {
            border-bottom: 1px solid #AAAAAA;
        }

        .background-green{
            background-color: #57B223;
            color: #FFFFFF;
        }

        .text-green{
            background-color: #e7e9eb;
            color: #57B223;
        }

        .text-dark-grey{
            background-color: #ced0d2;
        }

        #signatory img {
            height:95px;
            margin-bottom: -50px;
            margin-top: 5px;
            margin-right: 20;
        }

        <?php if($invoiceSetting->locale == 'th'): ?>

            table td {
            font-weight: bold !important;
            font-size: 20px !important;
            }

            .description
            {
                font-weight: bold !important;
                font-size: 16px !important;
            }
        <?php endif; ?>

        .client-logo {
            height:50px;
            margin-bottom:20px;
        }

    </style>
</head>

<body>
    <header class="clearfix"  class="description">

        <table cellpadding="0" cellspacing="0" class="billing">
            <tr>
                <td colspan="2">
                    <h1><?php echo app('translator')->get('app.invoice'); ?></h1>
                </td>
            </tr>
            <tr>
                <td id="invoiced_to">
                    <div  class="description">
                        <?php if($invoice->project && $invoice->project->client && $invoice->project->client->clientDetails && ($invoice->project->client->name || $invoice->project->client->email || $invoice->project->client->mobile || $invoice->project->client->clientDetails->company_name || $invoice->project->client->clientDetails->address) && ($invoiceSetting->show_client_name == 'yes' || $invoiceSetting->show_client_email == 'yes' || $invoiceSetting->show_client_phone == 'yes' || $invoiceSetting->show_client_company_name == 'yes' || $invoiceSetting->show_client_company_address == 'yes')): ?>
                            <?php if($invoice->clientDetails->company_logo): ?>
                                <div class="client-logo-div">
                                    <img src="<?php echo e($invoice->clientDetails->image_url); ?>"
                                        alt="<?php echo e($invoice->clientDetails->company_name); ?>" class="client-logo"/>
                                </div>
                            <?php endif; ?>

                            <small><?php echo app('translator')->get('modules.invoices.billedTo'); ?>:</small><br>

                            <?php if($invoice->project->client->name && $invoiceSetting->show_client_name == 'yes'): ?>
                                <?php echo e($invoice->project->client->name_salutation); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->project->client->email && $invoiceSetting->show_client_email == 'yes'): ?>
                                <?php echo e($invoice->project->client->email); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->project->client->mobile && $invoiceSetting->show_client_phone == 'yes'): ?>
                                <?php echo e($invoice->project->client->mobile_with_phonecode); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->project->client->clientDetails->company_name && $invoiceSetting->show_client_company_name == 'yes'): ?>
                                <?php echo e($invoice->project->client->clientDetails->company_name); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->project->client->clientDetails->address && $invoiceSetting->show_client_company_address == 'yes'): ?>
                                <?php echo nl2br($invoice->project->client->clientDetails->address); ?>

                            <?php endif; ?>

                            <?php if($invoice->show_shipping_address === 'yes'): ?>
                                <div>
                                    <div><?php echo app('translator')->get('app.shippingAddress'); ?> :</div>
                                    <div><?php echo nl2br($invoice->project->clientDetails->shipping_address); ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if($invoiceSetting->show_gst == 'yes' && !is_null($invoice->project->client->clientDetails->gst_number)): ?>
                                <div>
                                    <?php if($invoice->project->client->clientDetails->tax_name): ?>
                                        <span> <?php echo e($invoice->project->client->clientDetails->tax_name); ?>: <?php echo e($invoice->project->client->clientDetails->gst_number); ?></span>
                                    <?php else: ?>
                                        <span> <?php echo app('translator')->get('app.gstIn'); ?>: <?php echo e($invoice->project->client->clientDetails->gst_number); ?> </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php elseif($invoice->client && $invoice->clientDetails && ($invoice->client->name || $invoice->client->email || $invoice->client->mobile || $invoice->clientDetails->company_name || $invoice->clientDetails->address) && ($invoiceSetting->show_client_name == 'yes' || $invoiceSetting->show_client_email == 'yes' || $invoiceSetting->show_client_phone == 'yes' || $invoiceSetting->show_client_company_name == 'yes' || $invoiceSetting->show_client_company_address == 'yes')): ?>
                            <small><?php echo app('translator')->get('modules.invoices.billedTo'); ?>:</small><br>

                            <?php if($invoice->client->name && $invoiceSetting->show_client_name == 'yes'): ?>
                                <?php echo e($invoice->client->name_salutation); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->client->email && $invoiceSetting->show_client_email == 'yes'): ?>
                                <?php echo e($invoice->client->email); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->client->mobile && $invoiceSetting->show_client_phone == 'yes'): ?>
                                <?php echo e($invoice->client->mobile_with_phonecode); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->clientDetails->company_name && $invoiceSetting->show_client_company_name == 'yes'): ?>
                                <?php echo e($invoice->clientDetails->company_name); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->clientDetails->address && $invoiceSetting->show_client_company_address == 'yes'): ?>
                                <?php echo nl2br($invoice->clientDetails->address); ?>

                            <?php endif; ?>

                            <?php if($invoice->show_shipping_address === 'yes'): ?>
                                <div>
                                    <div><?php echo app('translator')->get('app.shippingAddress'); ?> :</div>
                                    <div><?php echo nl2br($invoice->clientDetails->shipping_address); ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if($invoiceSetting->show_gst == 'yes' && !is_null($invoice->clientDetails->gst_number)): ?>
                                <div>
                                    <?php if($invoice->clientDetails->tax_name): ?>
                                        <span> <?php echo e($invoice->clientDetails->tax_name); ?>: <?php echo e($invoice->clientDetails->gst_number); ?></span>
                                    <?php else: ?>
                                        <span> <?php echo app('translator')->get('app.gstIn'); ?>: <?php echo e($invoice->clientDetails->gst_number); ?> </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php elseif(is_null($invoice->project) && $invoice->estimate && $invoice->estimate->client && $invoice->estimate->client->clientDetails && ($invoiceSetting->show_client_name == 'yes' || $invoiceSetting->show_client_email == 'yes' || $invoiceSetting->show_client_phone == 'yes' || $invoiceSetting->show_client_company_name == 'yes' || $invoiceSetting->show_client_company_address == 'yes')): ?>
                            <small><?php echo app('translator')->get('modules.invoices.billedTo'); ?>:</small><br>

                            <?php if($invoice->estimate->client->name && $invoiceSetting->show_client_name == 'yes'): ?>
                                <?php echo e($invoice->estimate->client->name_salutation); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->estimate->client->email && $invoiceSetting->show_client_email == 'yes'): ?>
                                <?php echo e($invoice->estimate->client->email); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->estimate->client->mobile && $invoiceSetting->show_client_phone == 'yes'): ?>
                                <?php echo e($invoice->estimate->client->mobile_with_phonecode); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->estimate->client->clientDetails->company_name && $invoiceSetting->show_client_company_name == 'yes'): ?>
                                <?php echo e($invoice->estimate->client->clientDetails->company_name); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->estimate->client->clientDetails->address && $invoiceSetting->show_client_company_address == 'yes'): ?>
                                <?php echo nl2br($invoice->estimate->client->clientDetails->address); ?>

                            <?php endif; ?>

                            <?php if($invoice->show_shipping_address === 'yes'): ?>
                                <div>
                                    <div><?php echo app('translator')->get('app.shippingAddress'); ?> :</div>
                                    <div><?php echo nl2br($invoice->estimate->client->clientDetails->shipping_address); ?></div>
                                </div>
                            <?php endif; ?>
                            <?php if($invoiceSetting->show_gst == 'yes' && !is_null($invoice->estimate->client->clientDetails->gst_number)): ?>
                                <div>
                                    <?php if($invoice->estimate->client->clientDetails->tax_name): ?>
                                        <span> <?php echo e($invoice->estimate->client->clientDetails->tax_name); ?>: <?php echo e($invoice->estimate->client->clientDetails->gst_number); ?></span>
                                    <?php else: ?>
                                        <span> <?php echo app('translator')->get('app.gstIn'); ?>: <?php echo e($invoice->estimate->client->clientDetails->gst_number); ?> </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </td>
                <td>
                    <div id="company"  class="description">
                        <div id="logo">
                            <img src="<?php echo e($invoiceSetting->logo_url); ?>" alt="home" class="dark-logo" />
                        </div>
                        <small><?php echo app('translator')->get('modules.invoices.billedFrom'); ?>:</small>
                        <div><?php echo e($company->company_name); ?></div>
                        <?php if(!is_null($company) && $invoice->address): ?>
                        <?php if($company->company_email): ?>
                        <div><?php echo e($company->company_email); ?></div>
                        <?php endif; ?>
                        <?php if($company->company_phone): ?>
                        <div><?php echo e($company->company_phone); ?></div>
                        <?php endif; ?>
                        <div><?php echo nl2br($invoice->address->address); ?></div>
                        <?php endif; ?>
                        <?php if($invoiceSetting->show_gst == 'yes' && $invoice->address->tax_number): ?>
                            <div><?php echo e($invoice->address->tax_name); ?>: <?php echo e($invoice->address->tax_number); ?></div>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>
    </header>
    <main>
        <div id="details">
            <div id="invoice"  class="description">
                <h1><?php echo e($invoice->invoice_number); ?></h1>
                <?php if($creditNote): ?>
                    <div class=""><?php echo app('translator')->get('app.credit-note'); ?>: <?php echo e($creditNote->cn_number); ?></div>
                <?php endif; ?><?php echo e($invoice->invoice_number); ?></h1>
                <?php if($creditNote): ?>
                    <div class=""><?php echo app('translator')->get('app.credit-note'); ?>: <?php echo e($creditNote->cn_number); ?></div>
                <?php endif; ?>
                <div class="date"><?php echo app('translator')->get('modules.invoices.invoiceDate'); ?>:
                    <?php echo e($invoice->issue_date->translatedFormat($company->date_format)); ?></div>
                <?php if(empty($invoice->order_id) && $invoice->status === 'unpaid' && $invoice->due_date->year > 1): ?>
                    <div class="date"><?php echo app('translator')->get('app.dueDate'); ?>:
                        <?php echo e($invoice->due_date->translatedFormat($company->date_format)); ?></div>
                <?php endif; ?>
                <?php if($invoiceSetting->show_status): ?>
                <div class=""><?php echo app('translator')->get('app.status'); ?>: <?php echo app('translator')->get('modules.invoices.' . $invoice->status); ?></div>
                <?php endif; ?>
            </div>

            <p class="md-0 description">
                <?php if($invoiceSetting->show_project == 1 && isset($invoice->project->project_name)): ?>
                <small><?php echo app('translator')->get('modules.invoices.projectName'); ?></small><br>
                <?php echo e($invoice->project->project_name); ?>

                <?php endif; ?>
            </p>

        </div>
        <table cellspacing="0" cellpadding="0" id="invoice-table">
            <thead>
                <tr style="border-bottom: 1px solid #FFFFFF;">
                    <th class="no description background-green">#</th>
                    <th class="desc description"><?php echo app('translator')->get('modules.invoices.item'); ?></th>
                    <?php if($invoiceSetting->hsn_sac_code_show): ?>
                        <th class="qty description"><?php echo app('translator')->get('app.hsnSac'); ?></th>
                    <?php endif; ?>
                    <th class="qty description"><?php echo app('translator')->get('modules.invoices.qty'); ?></th>
                    <th class="qty description"><?php echo app('translator')->get('modules.invoices.unitPrice'); ?></th>
                    <th class="qty description"><?php echo app('translator')->get('modules.invoices.tax'); ?></th>
                    <th class="unit description text-dark-grey"><?php echo app('translator')->get('modules.invoices.price'); ?> (<?php echo htmlentities($invoice->currency->currency_code); ?>)</th>
                </tr>
            </thead>
            <tbody>
                <?php $count = 0; ?>
                <?php $__currentLoopData = $invoice->items->sortBy('field_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($item->type == 'item'): ?>
                        <tr style="page-break-inside: avoid;">
                            <td class="no background-green"><?php echo e(++$count); ?></td>
                            <td class="desc text-green">
                                <h3  class="description word-break"><?php echo e($item->item_name); ?></h3>
                                
                            </td>
                            <?php if($invoiceSetting->hsn_sac_code_show): ?>
                                <td class="qty text-green">
                                    <h3><?php echo e($item->hsn_sac_code ? $item->hsn_sac_code : '--'); ?></h3>
                                </td>
                            <?php endif; ?>
                            <td class="qty text-green">
                                <h3><?php echo e($item->quantity); ?><br><span class="item-summary" style="color:#555555;"><?php echo e($item->unit->unit_type); ?></h3>
                            </td>
                            <td class="qty text-green">
                                <h3><?php echo e(currency_format($item->unit_price, $invoice->currency_id, false)); ?></h3>
                            </td>
                            <td class="text-green"><?php echo e($item->tax_list); ?></td>
                            <td class="unit text-dark-grey"><?php echo e(currency_format($item->amount, $invoice->currency_id, false)); ?></td>
                        </tr>
                        <tr>
                            </table>
                            <div style="padding: 10px 10px 0px 20px">
                                <?php if(!is_null($item->item_summary)): ?>
                                    <?php echo nl2br(pdfStripTags($item->item_summary)); ?>

                                <?php endif; ?>
                                <?php if($item->invoiceItemImage): ?>
                                    <p class="mt-2">
                                        <img src="<?php echo e($item->invoiceItemImage->file_url); ?>" width="60" height="60" class="img-thumbnail">
                                    </p>
                                <?php endif; ?>
                            </div>
                            <table cellspacing="0" cellpadding="0" id="invoice-table">
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="page-break-inside: avoid;" class="subtotal">
                    <td class="no background-green">&nbsp;</td>
                    <td class="qty text-green">&nbsp;</td>
                    <td class="qty text-green">&nbsp;</td>
                    <td class="qty text-green">&nbsp;</td>
                    <?php if($invoiceSetting->hsn_sac_code_show): ?>
                        <td class="qty text-green">&nbsp;</td>
                    <?php endif; ?>
                    <td class="desc" style="background-color:#e7e9eb;"><?php echo app('translator')->get('modules.invoices.subTotal'); ?></td>
                    <td class="unit text-dark-grey"><?php echo e(currency_format($invoice->sub_total, $invoice->currency_id, false)); ?></td>
                </tr>
                <?php if($discount != 0 && $discount != ''): ?>
                    <tr style="page-break-inside: avoid;" class="discount">
                        <td class="no">&nbsp;</td>
                        <td class="qty">&nbsp;</td>
                        <td class="qty">&nbsp;</td>
                        <?php if($invoiceSetting->hsn_sac_code_show): ?>
                            <td class="qty">&nbsp;</td>
                        <?php endif; ?>
                        <td class="qty">&nbsp;</td>
                        <td class="desc"><?php echo app('translator')->get('modules.invoices.discount'); ?>:
                            <?php if($invoice->discount_type == 'percent'): ?>
                                <?php echo e($invoice->discount); ?>%
                            <?php else: ?>
                                <?php echo e(currency_format($invoice->discount, $invoice->currency_id)); ?>

                            <?php endif; ?>
                        </td>
                        <td class="unit border-left-0 border-right-0" style="border-bottom: 1px solid #e7e9eb;"><?php echo e(currency_format($discount, $invoice->currency_id, false)); ?></td>
                    </tr>
                <?php endif; ?>
                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="page-break-inside: avoid;" class="tax">
                        <td class="no">&nbsp;</td>
                        <td class="qty">&nbsp;</td>
                        <td class="qty">&nbsp;</td>
                        <?php if($invoiceSetting->hsn_sac_code_show): ?>
                            <td class="qty">&nbsp;</td>
                        <?php endif; ?>
                        <td class="qty">&nbsp;</td>
                        <td class="desc"><?php echo e($key); ?></td>
                        <td class="unit border-left-0 border-right-0" style="border-bottom: 1px solid #e7e9eb;"><?php echo e(currency_format($tax, $invoice->currency_id, false)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr dontbreak="true">
                    <td colspan="<?php echo e($invoiceSetting->hsn_sac_code_show ? '6' : '5'); ?>">
                        <?php echo app('translator')->get('modules.invoices.total'); ?></td>
                    <td style="text-align: center; border-bottom: 1px solid #e7e9eb;"><?php echo e(currency_format($invoice->total, $invoice->currency_id, false)); ?></td>
                </tr>
                <?php if($invoice->creditNotes()->count() > 0): ?>
                    <tr dontbreak="true">
                        <td colspan="<?php echo e($invoiceSetting->hsn_sac_code_show ? '6' : '5'); ?>">
                            <?php echo app('translator')->get('modules.invoices.appliedCredits'); ?></td>
                        <td style="text-align: center; border-bottom: 1px solid #e7e9eb;">
                            <?php echo e(currency_format($invoice->appliedCredits(), $invoice->currency_id, false)); ?></td>
                    </tr>
                <?php endif; ?>
                <tr dontbreak="true">
                    <td colspan="<?php echo e($invoiceSetting->hsn_sac_code_show ? '6' : '5'); ?>">
                        <?php echo app('translator')->get('app.totalPaid'); ?></td>
                    <td style="text-align: center; border-bottom: 1px solid #e7e9eb;"><?php echo e(currency_format($invoice->getPaidAmount(), $invoice->currency_id, false)); ?>

                    </td>
                </tr>
                <?php if($invoice->amountDue()): ?>
                <tr dontbreak="true">
                    <td colspan="<?php echo e($invoiceSetting->hsn_sac_code_show ? '6' : '5'); ?>">
                        <?php echo app('translator')->get('app.totalDue'); ?></td>
                    <td style="text-align: center; border-bottom: 1px solid #e7e9eb;"><?php echo e(currency_format($invoice->amountDue(), $invoice->currency_id, false)); ?>

                        <?php echo e($invoice->currency->currency_code); ?></td>
                </tr>
                <?php endif; ?>


                <?php if($invoiceSetting->authorised_signatory && $invoiceSetting->authorised_signatory_signature && $invoice->status == 'paid'): ?>
                    <tr>
                        <td id="signatory" colspan="<?php echo e($invoiceSetting->hsn_sac_code_show ? '7' : '6'); ?>" style="font-size:15px; border: 0" align="right">
                            <img src="<?php echo e($invoiceSetting->authorised_signatory_signature_url); ?>" alt="<?php echo e($company->company_name); ?>"/><br><br>
                            <p style="margin-top: 25px;"><?php echo app('translator')->get('modules.invoiceSettings.authorisedSignatory'); ?></p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tfoot>
        </table>

        <?php if ($__env->exists('invoices.payment_details')) echo $__env->make('invoices.payment_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <p id="notes" class="word-break description">
            <div>
                <?php if($invoice->note): ?>
                    <b><?php echo app('translator')->get('app.note'); ?></b><br><?php echo nl2br($invoice->note); ?><br>
                <?php endif; ?>
            </div>
            <div style="margin-top: 10px;">
                <b><?php echo app('translator')->get('modules.invoiceSettings.invoiceTerms'); ?></b><br><?php echo nl2br($invoiceSetting->invoice_terms); ?>

            </div>
        </p>

        <?php if(isset($invoiceSetting->other_info)): ?>
            <p class="description">
                <?php echo nl2br($invoiceSetting->other_info); ?>

            </p>
        <?php endif; ?>

        <?php if(isset($taxes) && $invoiceSetting->tax_calculation_msg == 1): ?>
            <p class="description">
                <?php if($invoice->calculate_tax == 'after_discount'): ?>
                    <?php echo app('translator')->get('messages.calculateTaxAfterDiscount'); ?>
                <?php else: ?>
                    <?php echo app('translator')->get('messages.calculateTaxBeforeDiscount'); ?>
                <?php endif; ?>
            </p>
        <?php endif; ?>

        
        <?php if(isset($fields) && count($fields) > 0): ?>
            <div class="page_break"></div>
            <h3 class="box-title m-t-20 text-center h3-border"> <?php echo app('translator')->get('modules.projects.otherInfo'); ?></h3>
            <table  style="background: none" border="0" cellspacing="0" cellpadding="0" width="100%">
                <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="text-align: left;background: none;" >
                            <div class="desc"><?php echo e($field->label); ?> </div>
                            <p id="notes">
                                <?php if( $field->type == 'text' || $field->type == 'password' || $field->type == 'number' || $field->type == 'textarea'): ?>
                                    <?php echo e($invoice->custom_fields_data['field_'.$field->id] ?? '-'); ?>

                                <?php elseif($field->type == 'radio'): ?>
                                    <?php echo e(!is_null($invoice->custom_fields_data['field_'.$field->id]) ? $invoice->custom_fields_data['field_'.$field->id] : '-'); ?>

                                <?php elseif($field->type == 'select'): ?>
                                    <?php echo e((!is_null($invoice->custom_fields_data['field_'.$field->id]) && $invoice->custom_fields_data['field_'.$field->id] != '') ? $field->values[$invoice->custom_fields_data['field_'.$field->id]] : '-'); ?>

                                <?php elseif($field->type == 'checkbox'): ?>
                                    <?php echo e(!is_null($invoice->custom_fields_data['field_'.$field->id]) ? $invoice->custom_fields_data['field_'.$field->id] : '-'); ?>

                                <?php elseif($field->type == 'date'): ?>
                                    <?php echo e(!is_null($invoice->custom_fields_data['field_'.$field->id]) ? \Carbon\Carbon::parse($invoice->custom_fields_data['field_'.$field->id])->translatedFormat($invoice->company->date_format) : '--'); ?>

                                <?php endif; ?>
                            </p>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
        <?php endif; ?>

        <?php if(count($payments) > 0): ?>
            <div class="page_break"></div>
            <div class="b-all m-t-20 m-b-20 text-center description">
                <h3 class="box-title m-t-20 text-center h3-border"> <?php echo app('translator')->get('app.menu.payments'); ?></h3>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="table-responsive m-t-40 description" style="clear: both;">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th class="text-center"><?php echo app('translator')->get('modules.invoices.price'); ?></th>
                                        <th class="text-center"><?php echo app('translator')->get('modules.invoices.paymentMethod'); ?></th>
                                        <th class="text-center"><?php echo app('translator')->get('modules.invoices.paidOn'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 0; ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($key + 1); ?></td>
                                            <td class="text-center">
                                                <?php echo e(currency_format($payment->amount, $invoice->currency_id, false)); ?>

                                                <?php echo $invoice->currency->currency_code; ?> </td>
                                            <td class="text-center">
                                                <?php
                                                    $method = '--';

                                                    if (!is_null($payment->offline_method_id)) {
                                                        $method = $payment->offlineMethod->name;
                                                    } elseif (isset($payment->gateway)) {
                                                        $method = $payment->gateway;
                                                    }
                                                ?>

                                                <?php echo e($method); ?>


                                            </td>
                                            <td class="text-center">
                                                <?php echo e($payment->paid_on->translatedFormat($company->date_format)); ?> </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </main>
</body>

</html>
<?php /**PATH /home/u174686079/domains/hansanienterprises.info/public_html/billing/resources/views/invoices/pdf/invoice-1.blade.php ENDPATH**/ ?>