<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class LineItem extends \Google\Model
{
  protected $listingPriceType = Money::class;
  protected $listingPriceDataType = '';
  protected $oneTimePurchaseDetailsType = OneTimePurchaseDetails::class;
  protected $oneTimePurchaseDetailsDataType = '';
  protected $paidAppDetailsType = PaidAppDetails::class;
  protected $paidAppDetailsDataType = '';
  /**
   * @var string
   */
  public $productId;
  /**
   * @var string
   */
  public $productTitle;
  protected $subscriptionDetailsType = SubscriptionDetails::class;
  protected $subscriptionDetailsDataType = '';
  protected $taxType = Money::class;
  protected $taxDataType = '';
  protected $totalType = Money::class;
  protected $totalDataType = '';

  /**
   * @param Money
   */
  public function setListingPrice(Money $listingPrice)
  {
    $this->listingPrice = $listingPrice;
  }
  /**
   * @return Money
   */
  public function getListingPrice()
  {
    return $this->listingPrice;
  }
  /**
   * @param OneTimePurchaseDetails
   */
  public function setOneTimePurchaseDetails(OneTimePurchaseDetails $oneTimePurchaseDetails)
  {
    $this->oneTimePurchaseDetails = $oneTimePurchaseDetails;
  }
  /**
   * @return OneTimePurchaseDetails
   */
  public function getOneTimePurchaseDetails()
  {
    return $this->oneTimePurchaseDetails;
  }
  /**
   * @param PaidAppDetails
   */
  public function setPaidAppDetails(PaidAppDetails $paidAppDetails)
  {
    $this->paidAppDetails = $paidAppDetails;
  }
  /**
   * @return PaidAppDetails
   */
  public function getPaidAppDetails()
  {
    return $this->paidAppDetails;
  }
  /**
   * @param string
   */
  public function setProductId($productId)
  {
    $this->productId = $productId;
  }
  /**
   * @return string
   */
  public function getProductId()
  {
    return $this->productId;
  }
  /**
   * @param string
   */
  public function setProductTitle($productTitle)
  {
    $this->productTitle = $productTitle;
  }
  /**
   * @return string
   */
  public function getProductTitle()
  {
    return $this->productTitle;
  }
  /**
   * @param SubscriptionDetails
   */
  public function setSubscriptionDetails(SubscriptionDetails $subscriptionDetails)
  {
    $this->subscriptionDetails = $subscriptionDetails;
  }
  /**
   * @return SubscriptionDetails
   */
  public function getSubscriptionDetails()
  {
    return $this->subscriptionDetails;
  }
  /**
   * @param Money
   */
  public function setTax(Money $tax)
  {
    $this->tax = $tax;
  }
  /**
   * @return Money
   */
  public function getTax()
  {
    return $this->tax;
  }
  /**
   * @param Money
   */
  public function setTotal(Money $total)
  {
    $this->total = $total;
  }
  /**
   * @return Money
   */
  public function getTotal()
  {
    return $this->total;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LineItem::class, 'Google_Service_AndroidPublisher_LineItem');
